/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.util.JsonHelper;

public abstract class FluidIngredient {
    public static final FluidIngredient EMPTY = new Empty();
    public static Serializer SERIALIZER = new Serializer();
    private List<FluidStack> displayFluids;

    public abstract boolean test(class_3611 var1);

    public abstract long getAmount(class_3611 var1);

    public boolean test(FluidStack stack) {
        class_3611 fluid = stack.getFluid();
        return stack.getAmount() >= this.getAmount(fluid) && this.test(stack.getFluid());
    }

    public List<FluidStack> getFluids() {
        if (this.displayFluids == null) {
            this.displayFluids = this.getAllFluids().stream().filter(stack -> {
                class_3611 fluid = stack.getFluid();
                return fluid.method_15793(fluid.method_15785());
            }).collect(Collectors.toList());
        }
        return this.displayFluids;
    }

    protected abstract List<FluidStack> getAllFluids();

    public abstract JsonElement serialize();

    public void write(class_2540 buffer) {
        List<FluidStack> fluids = this.getAllFluids();
        buffer.writeInt(fluids.size());
        for (FluidStack stack : fluids) {
            buffer.method_10814(Objects.requireNonNull(class_7923.field_41173.method_10221((Object)stack.getFluid())).toString());
            buffer.writeLong(stack.getAmount());
        }
    }

    public static FluidIngredient of(class_3611 fluid, long amount) {
        return new FluidMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        return FluidIngredient.of(stack.getFluid(), stack.getAmount());
    }

    public static FluidIngredient of(class_6862<class_3611> fluid, long amount) {
        return new TagMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidIngredient ... ingredients) {
        return new Compound(ingredients);
    }

    public static FluidIngredient deserialize(JsonObject parent, String name) {
        return FluidIngredient.deserialize(JsonHelper.getElement(parent, name), name);
    }

    public static FluidIngredient deserialize(JsonElement json, String name) {
        if (json.isJsonObject()) {
            return FluidIngredient.deserializeObject(json.getAsJsonObject());
        }
        if (json.isJsonArray()) {
            return Compound.deserialize(json.getAsJsonArray(), name);
        }
        throw new JsonSyntaxException("Fluid ingredient " + name + " must be either an object or array");
    }

    private static FluidIngredient deserializeObject(JsonObject json) {
        if (json.entrySet().isEmpty()) {
            return EMPTY;
        }
        if (json.has("name")) {
            if (json.has("tag")) {
                throw new JsonSyntaxException("An ingredient entry is either a tag or an fluid, not both");
            }
            return FluidMatch.deserialize(json);
        }
        if (json.has("tag")) {
            return TagMatch.deserialize(json);
        }
        throw new JsonSyntaxException("An ingredient entry needs either a tag or an fluid");
    }

    public static FluidIngredient read(class_2540 buffer) {
        int count = buffer.readInt();
        FluidIngredient[] ingredients = new FluidIngredient[count];
        for (int i = 0; i < count; ++i) {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(buffer.method_10800(Short.MAX_VALUE)));
            if (fluid == null) {
                fluid = class_3612.field_15906;
            }
            long amount = buffer.readLong();
            ingredients[i] = FluidIngredient.of(fluid, amount);
        }
        if (count == 1) {
            return ingredients[0];
        }
        return FluidIngredient.of(ingredients);
    }

    private static class FluidMatch
    extends FluidIngredient {
        private final class_3611 fluid;
        private final long amount;

        @Override
        public boolean test(class_3611 fluid) {
            return fluid == this.fluid;
        }

        @Override
        public long getAmount(class_3611 fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return Collections.singletonList(new FluidStack(this.fluid, this.amount));
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("name", Objects.requireNonNull(class_7923.field_41173.method_10221((Object)this.fluid)).toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        @Override
        public void write(class_2540 buffer) {
            buffer.writeInt(1);
            buffer.method_10814(Objects.requireNonNull(class_7923.field_41173.method_10221((Object)this.fluid)).toString());
            buffer.writeLong(this.amount);
        }

        private static FluidMatch deserialize(JsonObject json) {
            String fluidName = class_3518.method_15265((JsonObject)json, (String)"name");
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(fluidName));
            if (fluid == null || fluid == class_3612.field_15906) {
                throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
            }
            long amount = class_3518.method_22449((JsonObject)json, (String)"amount");
            return new FluidMatch(fluid, amount);
        }

        private FluidMatch(class_3611 fluid, long amount) {
            this.fluid = fluid;
            this.amount = amount;
        }
    }

    private static class TagMatch
    extends FluidIngredient {
        private final class_6862<class_3611> tag;
        private final long amount;

        @Override
        public boolean test(class_3611 fluid) {
            return fluid.method_15791(this.tag);
        }

        @Override
        public long getAmount(class_3611 fluid) {
            return this.amount;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return StreamSupport.stream(class_7923.field_41173.method_40286(this.tag).spliterator(), false).filter(class_6880::method_40227).map(fluid -> new FluidStack((class_3611)fluid.comp_349(), this.amount)).toList();
        }

        @Override
        public JsonElement serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("tag", this.tag.comp_327().toString());
            object.addProperty("amount", (Number)this.amount);
            return object;
        }

        private static TagMatch deserialize(JsonObject json) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)JsonHelper.getResourceLocation(json, "tag"));
            long amount = class_3518.method_22449((JsonObject)json, (String)"amount");
            return new TagMatch((class_6862<class_3611>)tag, amount);
        }

        private TagMatch(class_6862<class_3611> tag, long amount) {
            this.tag = tag;
            this.amount = amount;
        }
    }

    private static class Compound
    extends FluidIngredient {
        private final List<FluidIngredient> ingredients;

        private Compound(FluidIngredient[] ingredients) {
            this.ingredients = Arrays.asList(ingredients);
        }

        @Override
        public boolean test(class_3611 fluid) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(fluid));
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public long getAmount(class_3611 fluid) {
            return this.ingredients.stream().filter(ingredient -> ingredient.test(fluid)).mapToLong(ingredient -> ingredient.getAmount(fluid)).findFirst().orElse(0L);
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return this.ingredients.stream().flatMap(ingredient -> ingredient.getFluids().stream()).collect(Collectors.toList());
        }

        @Override
        public JsonElement serialize() {
            return (JsonElement)this.ingredients.stream().map(FluidIngredient::serialize).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        }

        private static Compound deserialize(JsonArray array, String name) {
            int size = array.size();
            if (size == 0) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
            }
            FluidIngredient[] ingredients = new FluidIngredient[size];
            for (int i = 0; i < size; ++i) {
                ingredients[i] = FluidIngredient.deserializeObject(class_3518.method_15295((JsonElement)array.get(i), (String)(name + "[" + i + "]")));
            }
            return new Compound(ingredients);
        }
    }

    private static class Empty
    extends FluidIngredient {
        @Override
        public boolean test(class_3611 fluid) {
            return fluid == class_3612.field_15906;
        }

        @Override
        public boolean test(FluidStack fluid) {
            return fluid.isEmpty();
        }

        @Override
        public long getAmount(class_3611 fluid) {
            return 0L;
        }

        @Override
        public List<FluidStack> getAllFluids() {
            return Collections.emptyList();
        }

        @Override
        public JsonElement serialize() {
            return new JsonObject();
        }

        private Empty() {
        }
    }

    public static class Serializer
    implements JsonDeserializer<FluidIngredient>,
    JsonSerializer<FluidIngredient> {
        private Serializer() {
        }

        public FluidIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return FluidIngredient.deserialize(json, "ingredient");
        }

        public JsonElement serialize(FluidIngredient src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize();
        }
    }
}

